/*
 * QrfePropertyObject.h
 *
 *  Created on: 01.08.2011
 *      Author: stefan.detter
 */

#ifndef QRFEPROPERTYOBJECT_H_
#define QRFEPROPERTYOBJECT_H_

#include <QObject>
#include <QVariant>
#include <QPair>
#include <QMetaObject>
#include <QStringList>

typedef enum
{
	EDIT_READ_ONLY,
	EDIT_TEXT,
	EDIT_RANGE,
	EDIT_LIST,
	EDIT_FILENAME,
} QrfePropertyEditType;

class QrfePropertyEditRange
{
public:
	QrfePropertyEditRange(){m_min = 0; m_max = 1;}
	QrfePropertyEditRange(int min, int max){m_min = min; m_max = max;}
	QrfePropertyEditRange(const QrfePropertyEditRange& other){m_min = other.m_min; m_max = other.m_max;}
	virtual ~QrfePropertyEditRange(){}

	int min() const{return m_min;}
	int max() const{return m_max;}

	static int MAX;
	static int MIN;

private:
	int m_min;
	int m_max;
} ;
Q_DECLARE_METATYPE(QrfePropertyEditRange)

typedef QStringList QrfePropertyEditList;
Q_DECLARE_METATYPE(QrfePropertyEditList)

typedef QString QrfePropertyEditPattern;
Q_DECLARE_METATYPE(QrfePropertyEditPattern)

typedef bool (*QrfeValidationFunction) (const QVariant &);

class QrfePropertyObject : public QObject
{
	Q_OBJECT

public:
	QrfePropertyObject(QObject* parent = 0);
	virtual ~QrfePropertyObject();

	virtual QStringList	propertyNames () const;
	virtual QVariant	property ( const QString & name ) const;
	virtual bool 		setProperty ( const QString & name, const QVariant & value );
	virtual bool 		validateNewValue ( const QString & name, const QVariant& value );

	virtual QrfePropertyEditType 	propertyEditType( const QString & name ) const;
	virtual QVariant			 	propertyEditParams( const QString & name ) const;

	virtual QString 	propertyDescription( const QString & name ) const;

protected:
	void registerPropertyEditInformation ( const QString& property, QrfePropertyEditType editType, QVariant param = QVariant("") );
	void registerPropertyEditInformation ( const QString& property, QrfePropertyEditType editType, QrfePropertyEditRange param);
	void registerPropertyEditInformation ( const QString& property, QrfePropertyEditType editType, QrfePropertyEditList param);
	void registerPropertyEditInformation ( const QString& property, QrfePropertyEditType editType, QrfePropertyEditPattern param);

	void registerPropertyDescription ( const QString& property, const QString& description );
	void registerPropertyValidation ( const QString& property, QrfeValidationFunction validation );

protected:
	QMap<QString, QPair<QrfePropertyEditType,QVariant> > 	m_editInformations;
	QMap<QString, QrfeValidationFunction> 					m_validationFunctions;
	QMap<QString, QString>									m_propertyDescription;
};

#endif /* QRFEPROPERTYOBJECT_H_ */
